ALTER TABLE `news` 
  ADD `company` varchar(255) default NULL;

ALTER TABLE `instruments` 
  ADD `maxlevel` double default NULL,
  ADD `numberofprefshares` bigint(20) unsigned default NULL;

ALTER TABLE `fundamentals`
  DROP `orderintake`,
  DROP `orderbacklog`,
  DROP `netinterestincome`,
  DROP `netfeeandcomincome`,
  DROP `toe`,
  DROP `toi`,
  DROP `profitbeforewacl`,
  DROP `creditloss`,
  DROP `rentalincome`,
  DROP `propertymgmtresult`,
  DROP `realizedchgprop`,
  DROP `unrealizedchgprop`,
  DROP `returnonequity`,
  DROP `adjustedequity`,
  DROP `totliabilities`,
  ADD `interestincome` double default NULL,
  ADD `otherfinancialincome` double default NULL,
  ADD `interestexpense` double default NULL,
  ADD `otherfinancialexpense` double default NULL,
  ADD `minorityinterestres` double default NULL,
  ADD `accountspayable` double default NULL,
  ADD `eventlink` char(36) default NULL,
  ADD `eventlinklanguages` varchar(255) default NULL;

ALTER TABLE `corporateactions`
  DROP `dividendoriginal`,
  ADD `eventlink` char(36) default NULL,
  ADD `eventlinklanguages` varchar(255) default NULL,
  ADD `numberofprefshares` bigint(20) unsigned default NULL;

ALTER TABLE `performance`
  ADD `annualizedreturn1y` double default NULL,
  ADD `annualizedreturn2y` double default NULL,
  ADD `annualizedreturn4y` double default NULL;

ALTER TABLE `l10n`
  ADD `sustaindescription` mediumtext default NULL,
  ADD `sustaininvesting1` mediumtext default NULL,
  ADD `sustaininvesting2` mediumtext default NULL,
  ADD `sustaindivesting1` mediumtext default NULL,
  ADD `sustaindivesting2` mediumtext default NULL,
  ADD `sustaininfluence` mediumtext default NULL,
  ADD `sustainmonitoring1` mediumtext default NULL,
  ADD `sustainmonitoring2` mediumtext default NULL,
  ADD `sustaincomment` mediumtext default NULL;

ALTER TABLE `pricehistory` ADD `settlementprice` double default NULL;
ALTER TABLE `adjustedpricehistory` ADD `settlementprice` double default NULL;

ALTER TABLE `newscoding` ADD `date` date default NULL;

CREATE TABLE IF NOT EXISTS `ci` (
  `insref` bigint(20) unsigned NOT NULL,
  `type` smallint(5) unsigned NOT NULL,
  `subtype` smallint(5) unsigned default NULL,
  `sequence` integer unsigned NOT NULL,
  `s1` varchar(255) default NULL,
  `s2` varchar(255) default NULL,
  `s3` varchar(255) default NULL,
  `s4` varchar(255) default NULL,
  `s5` varchar(255) default NULL,
  `s6` varchar(255) default NULL,
  `s7` varchar(255) default NULL,
  `s8` varchar(255) default NULL,
  `s9` varchar(255) default NULL,
  `s10` varchar(255) default NULL,
  `n1` double default NULL,
  `n2` double default NULL,
  `n3` double default NULL,
  `n4` double default NULL,
  `n5` double default NULL,
  `i1` integer default NULL,
  `i2` integer default NULL,
  `i3` integer default NULL,
  `i4` integer default NULL,
  `i5` integer default NULL,
  `d1` date default NULL,
  `d2` date default NULL,
  `d3` date default NULL,
  PRIMARY KEY  (`insref`, `type`, `sequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `cihistory` (
  `insref` bigint(20) unsigned NOT NULL,
  `type` smallint(5) unsigned NOT NULL,
  `subtype` smallint(5) unsigned default NULL,
  `sequence` integer unsigned NOT NULL,
  `date` date NOT NULL,
  `s1` varchar(255) default NULL,
  `s2` varchar(255) default NULL,
  `s3` varchar(255) default NULL,
  `s4` varchar(255) default NULL,
  `s5` varchar(255) default NULL,
  `s6` varchar(255) default NULL,
  `s7` varchar(255) default NULL,
  `s8` varchar(255) default NULL,
  `s9` varchar(255) default NULL,
  `s10` varchar(255) default NULL,
  `n1` double default NULL,
  `n2` double default NULL,
  `n3` double default NULL,
  `n4` double default NULL,
  `n5` double default NULL,
  `i1` integer default NULL,
  `i2` integer default NULL,
  `i3` integer default NULL,
  `i4` integer default NULL,
  `i5` integer default NULL,
  `d1` date default NULL,
  `d2` date default NULL,
  `d3` date default NULL,
  PRIMARY KEY  (`insref`, `type`, `sequence`, `date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

