ALTER TABLE news 
  ADD COLUMN "company" character varying(255);

ALTER TABLE instruments 
  ADD COLUMN "maxlevel" double precision,
  ADD COLUMN "numberofprefshares" numeric(20);

ALTER TABLE fundamentals
  DROP COLUMN "orderintake",
  DROP COLUMN "orderbacklog",
  DROP COLUMN "netinterestincome",
  DROP COLUMN "netfeeandcomincome",
  DROP COLUMN "toe",
  DROP COLUMN "toi",
  DROP COLUMN "profitbeforewacl",
  DROP COLUMN "creditloss",
  DROP COLUMN "rentalincome",
  DROP COLUMN "propertymgmtresult",
  DROP COLUMN "realizedchgprop",
  DROP COLUMN "unrealizedchgprop",
  DROP COLUMN "returnonequity",
  DROP COLUMN "adjustedequity",
  DROP COLUMN "totliabilities",
  ADD COLUMN "interestincome" double precision,
  ADD COLUMN "otherfinancialincome" double precision,
  ADD COLUMN "interestexpense" double precision,
  ADD COLUMN "otherfinancialexpense" double precision,
  ADD COLUMN "minorityinterestres" double precision,
  ADD COLUMN "accountspayable" double precision,
  ADD COLUMN "eventlink" character(36),
  ADD COLUMN "eventlinklanguages" character varying(255);

ALTER TABLE corporateactions
  DROP COLUMN "dividendoriginal",
  ADD COLUMN "eventlink" character(36),
  ADD COLUMN "eventlinklanguages" character varying(255),
  ADD COLUMN "numberofprefshares" numeric(20);

ALTER TABLE performance
  ADD COLUMN "annualizedreturn1y" double precision,
  ADD COLUMN "annualizedreturn2y" double precision,
  ADD COLUMN "annualizedreturn4y" double precision;

ALTER TABLE l10n
  ADD COLUMN "sustaindescription" text,
  ADD COLUMN "sustaininvesting1" text,
  ADD COLUMN "sustaininvesting2" text,
  ADD COLUMN "sustaindivesting1" text,
  ADD COLUMN "sustaindivesting2" text,
  ADD COLUMN "sustaininfluence" text,
  ADD COLUMN "sustainmonitoring1" text,
  ADD COLUMN "sustainmonitoring2" text,
  ADD COLUMN "sustaincomment" text;

ALTER TABLE pricehistory ADD COLUMN "settlementprice" double precision;
ALTER TABLE adjustedpricehistory ADD COLUMN "settlementprice" double precision;

ALTER TABLE newscoding ADD COLUMN "date" date;

CREATE TABLE ci (
  "insref" numeric(20) NOT NULL,
  "type" smallint NOT NULL,
  "subtype" smallint,
  "sequence" integer NOT NULL,
  "s1" character varying(255),
  "s2" character varying(255),
  "s3" character varying(255),
  "s4" character varying(255),
  "s5" character varying(255),
  "s6" character varying(255),
  "s7" character varying(255),
  "s8" character varying(255),
  "s9" character varying(255),
  "s10" character varying(255),
  "n1" double precision,
  "n2" double precision,
  "n3" double precision,
  "n4" double precision,
  "n5" double precision,
  "i1" integer,
  "i2" integer,
  "i3" integer,
  "i4" integer,
  "i5" integer,
  "d1" date,
  "d2" date,
  "d3" date,
  CONSTRAINT ci_pk PRIMARY KEY ("insref","type","sequence")
);

CREATE TABLE cihistory (
  "insref" numeric(20) NOT NULL,
  "type" smallint NOT NULL,
  "subtype" smallint,
  "sequence" integer NOT NULL,
  "date" date NOT NULL,
  "s1" character varying(255),
  "s2" character varying(255),
  "s3" character varying(255),
  "s4" character varying(255),
  "s5" character varying(255),
  "s6" character varying(255),
  "s7" character varying(255),
  "s8" character varying(255),
  "s9" character varying(255),
  "s10" character varying(255),
  "n1" double precision,
  "n2" double precision,
  "n3" double precision,
  "n4" double precision,
  "n5" double precision,
  "i1" integer,
  "i2" integer,
  "i3" integer,
  "i4" integer,
  "i5" integer,
  "d1" date,
  "d2" date,
  "d3" date,
  CONSTRAINT cihistory_pk PRIMARY KEY ("insref","type","sequence","date")
);

