ALTER TABLE [dbo].[trades] ALTER COLUMN [tradequantity] [float] NULL;
ALTER TABLE [dbo].[trades] ADD [mmt] [char](14) COLLATE Latin1_General_CS_AS NULL;
ALTER TABLE [dbo].[orderbooks] ALTER COLUMN [quantity] [float] NULL;

ALTER TABLE [dbo].[l10n] ADD 
	[Comprehension_Alert_Portfolio] [char](1) NULL,
	[Intended_target_market_retail_investor_Portfolio] [nvarchar](750) NULL,
	[Investment_objective_Portfolio] [nvarchar](2500) NULL,
	[Risk_narrative_Portfolio] [nvarchar](300) NULL,
	[Other_materially_relevant_risk_narrative_Portfolio] [nvarchar](200) NULL,
	[Type_of_underlying_Investment_Option] [nvarchar](300) NULL,
	[Capital_Guarantee] [char](1) NULL,
	[Capital_Guarantee_Level] [float] NULL,
	[Capital_Guarantee_Limitations] [nvarchar](300) NULL,
	[Capital_Guarantee_Early_Exit_Conditions] [date] NULL,
	[Capital_guarantee_Portfolio] [nvarchar](2500) NULL,
	[Possible_maximum_loss_Portfolio] [float] NULL,
	[Portfolio_Performance_Fees_Narrative] [nvarchar](300) NULL,
	[Portolio_Carried_Interest_Narrative] [nvarchar](300) NULL,
	[Other_comment] [nvarchar](max) NULL;
GO

CREATE TABLE [dbo].[priip] (
	[insref] [numeric](20, 0) NOT NULL,
	[Portfolio_Issuer_Name] [nvarchar](255) NULL,
	[Portfolio_Guarantor_Name] [nvarchar](255) NULL,
	[Portfolio_Identifying_Data] [varchar](255) NULL,
	[Type_Of_Identification_Code_For_The_Fund_Share_Or_Portfolio] [smallint] NULL,
	[Portfolio_Name] [nvarchar](255) NULL,
	[Share_Class_Currency] [char](3) NULL,
	[Reference_Date] [date] NULL,
	[Portfolio_PRIIPS_Category] [smallint] NULL,
	[Fund_CIC_code] [char](4) NULL,
	[EOS_portfolio] [char](1) NULL,
	[Valuation_Frequency] [smallint] NULL,
	[Portfolio_VEV_Reference] [float] NULL,
	[IS_Flexible] [char](1) NULL,
	[Flex_VEV_Historical] [float] NULL,
	[Flex_VEV_Ref_Asset_Allocation] [float] NULL,
	[IS_Risk_Limit_Relevant] [char](1) NULL,
	[Flex_VEV_Risk_Limit] [float] NULL,
	[Existing_Credit_Risk] [char](1) NULL,
	[SRI] [smallint] NULL,
	[MRM] [smallint] NULL,
	[CRM] [smallint] NULL,
	[Recommended_Holding_Period] [float] NULL,
	[Maturity_Date] [date] NULL,
	[Liquidity_Risk] [char](1) NULL,
	[Portfolio_return_unfavorable_scenario_1_year] [float] NULL,
	[Portfolio_return_unfavorable_scenario_half_RHP] [float] NULL,
	[Portfolio_return_unfavorable_scenario_RHP] [float] NULL,
	[Portfolio_return_moderate_scenario_1_year] [float] NULL,
	[Portfolio_return_moderate_scenario_half_RHP] [float] NULL,
	[Portfolio_return_moderate_scenario_RHP] [float] NULL,
	[Portfolio_return_favorable_scenario_1_year] [float] NULL,
	[Portfolio_return_favorable_scenario_half_RHP] [float] NULL,
	[Portfolio_return] [float] NULL,
	[Portfolio_return_stress_scenario_1_year] [float] NULL,
	[Portfolio_return_stress_scenario_half_RHP] [float] NULL,
	[Portfolio_return_stress_scenario_RHP] [float] NULL,
	[Portfolio_number_of_observed_return_M0] [float] NULL,
	[Portfolio_mean_observed_returns_M1] [float] NULL,
	[Portfolio_observed_Sigma] [float] NULL,
	[Portfolio_observed_Skewness] [float] NULL,
	[Portfolio_observed_Excess_Kurtosis] [float] NULL,
	[Portfolio_observed_Stressed_Volatility] [float] NULL,
	[One_off_cost_Portfolio_entry_cost] [float] NULL,
	[One_off_cost_Portfolio_entry_cost_Acquired] [float] NULL,
	[One_off_costs_Portfolio_exit_cost_at_RHP] [float] NULL,
	[One_off_costs_Portfolio_exit_cost_at_1_year] [float] NULL,
	[One_off_costs_Portfolio_exit_cost_at_half_RHP] [float] NULL,
	[One_off_costs_Portfolio_sliding_exit_cost_Indicator] [char](1) NULL,
	[Ongoing_costs_Portfolio_other_costs] [float] NULL,
	[Ongoing_costs_Portfolio_management_costs] [float] NULL,
	[Ongoing_costs_Portfolio_transaction_costs] [float] NULL,
	[Existing_performance_fees] [char](1) NULL,
	[Incidental_costs_Portfolio_performance_fees] [float] NULL,
	[Existing_carried_interest_fees] [char](1) NULL,
	[Incidental_costs_Portfolio_carried_interest] [float] NULL,
	[Reference_Language] [char](2) NULL,
	[Comprehension_Alert_Portfolio] [char](1) NULL,
	[Intended_target_market_retail_investor_Portfolio] [nvarchar](750) NULL,
	[Investment_objective_Portfolio] [nvarchar](2500) NULL,
	[Risk_narrative_Portfolio] [nvarchar](300) NULL,
	[Other_materially_relevant_risk_narrative_Portfolio] [nvarchar](200) NULL,
	[Type_of_underlying_Investment_Option] [nvarchar](300) NULL,
	[Capital_Guarantee] [char](1) NULL,
	[Capital_Guarantee_Level] [float] NULL,
	[Capital_Guarantee_Limitations] [nvarchar](300) NULL,
	[Capital_Guarantee_Early_Exit_Conditions] [date] NULL,
	[Capital_guarantee_Portfolio] [nvarchar](2500) NULL,
	[Possible_maximum_loss_Portfolio] [float] NULL,
	[Portfolio_Performance_Fees_Narrative] [nvarchar](300) NULL,
	[Portolio_Carried_Interest_Narrative] [nvarchar](300) NULL,
	[Other_comment] [nvarchar](max) NULL,
	[PRIIP_data_delivery] [char](1) NULL,
	[UCITS_data_delivery] [char](1) NULL,
	[Portfolio_UCITS_SRRI] [smallint] NULL,
	[Portfolio_UCITS_Vol] [float] NULL,
	[Ongoing_costs_Portfolio_other_costs_UCITS] [float] NULL,
	[Ongoing_costs_Portfolio_transaction_costs_UCITS] [float] NULL,
	[Transactions_costs_methodology] [nvarchar](255) NULL,
	[Incidental_costs_Portfolio_performance_fees_UCITS] [float] NULL,
	[Incidental_costs_Portfolio_carried_interest_UCITS] [float] NULL,
	[UCITS_KID_Web_Address] [nvarchar](max) NULL,
	[Bonds_Weight] [float] NULL,
	[Annualized_Return_Volatility] [float] NULL,
	[Duration_Bonds] [float] NULL,
	[Existing_Capital_Preservation] [char](1) NULL,
	[Capital_Preservation_Level] [float] NULL,
	[Time_Interval_Maximum_Loss] [varchar](10) NULL,
	[Uses_PI] [char](1) NULL,
	[Multiplier_PI] [float] NULL,
	[Total_cost_1_year] [float] NULL,
	[RIY_1_year] [float] NULL,
	[Total_cost_half_RHP] [float] NULL,
	[RIY_half_RHP] [float] NULL,
	[Total_cost_RHP] [float] NULL,
	[RIY_RHP] [float] NULL,
	[One_off_costs_Portfolio_entry_cost_RIY] [float] NULL,
	[One_off_costs_Portfolio_exit_cost_RIY] [float] NULL,
	[Ongoing_costs_Portfolio_transaction_costs_RIY] [float] NULL,
	[Ongoing_costs_Other_ongoing_costs_RIY] [float] NULL,
	[Incidental_costs_Portfolio_performance_fees_RIY] [float] NULL,
	[Incidental_costs_Portfolio_carried_interests_RIY] [float] NULL,
	CONSTRAINT [priip_pk] PRIMARY KEY CLUSTERED ([insref] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[mifid] (
	[insref] [numeric](20, 0) NOT NULL,
	[fisn] [varchar](35) NULL,
	[lei] [char](20) NULL,
	[Financial_Instrument_Identifying_Data] [varchar](255) NULL,
	[Type_Of_Identification_Code_For_The_Financial_Instrument] [smallint] NULL,
	[Financial_Instrument_Name] [nvarchar](255) NULL,
	[Financial_Instrument_Currency] [char](3) NULL,
	[Reporting_Date] [date] NULL,
	[Financial_Instrument_Legal_Structure] [varchar](2) NULL,
	[Financial_Instrument_Issuer_Name] [nvarchar](255) NULL,
	[Financial_Instrument_Guarantor_Name] [nvarchar](255) NULL,
	[Product_Category_or_Nature] [nvarchar](255) NULL,
	[Leveraged_Financial_Instrument_or_Contingent_LiabilityInstrumen] [char](1) NULL,
	[Investor_Type_Retail] [char](1) NULL,
	[Investor_Type_Professional] [char](1) NULL,
	[Investor_Type_Eligible_Counterparty] [char](1) NULL,
	[Basic_Investor] [char](1) NULL,
	[Informed_Investor] [char](1) NULL,
	[Advanced_Investor] [char](1) NULL,
	[Expert_Investor_Germany] [char](1) NULL,
	[No_Capital_Loss] [char](1) NULL,
	[Limited_Capital_Loss] [char](1) NULL,
	[Limited_Capital_Loss_Level] [float] NULL,
	[No_Capital_Guarantee] [char](1) NULL,
	[Loss_Beyond_Capital] [char](1) NULL,
	[Risk_Tolerance_PRIIPS_Methodology] [smallint] NULL,
	[Risk_Tolerance_UCITS_Metholodology] [smallint] NULL,
	[Risk_Tolerance_Internal_Methodology_For_Non_PRIIPS_and_NonUCITS] [char](1) NULL,
	[Risk_Tolerance_For_Non_PRIIPS_and_Non_UCITS_Spain] [smallint] NULL,
	[Not_For_Investors_With_The_Lowest_Risk_Tolerance_Germany] [char](1) NULL,
	[Return_Profile_Preservation] [char](1) NULL,
	[Return_Profile_Growth] [char](1) NULL,
	[Return_Profile_Income] [char](1) NULL,
	[Return_Profile_Hedging] [char](1) NULL,
	[Option_or_Leveraged_Return_Profile] [char](1) NULL,
	[Return_Profile_Other] [char](1) NULL,
	[Return_Profile_Pension_Scheme_Germany] [char](1) NULL,
	[Time_Horizon1] [char](1) NULL,
	[Time_Horizon2] [float] NULL,
	[Maturity_Date] [date] NULL,
	[May_Be_Terminated_Early] [char](1) NULL,
	[Specific_Investment_Need] [char](1) NULL,
	[Execution_Only] [char](1) NULL,
	[Execution_With_Appropriateness_Test_Or_Non_Advised_Services] [char](1) NULL,
	[Investment_Advice] [char](1) NULL,
	[Portfolio_Management] [char](1) NULL,
	[Structured_Securities_Quotation] [char](1) NULL,
	[OO_Financial_Instrument_entry_cost] [float] NULL,
	[OO_Financial_Instrument_maximum_entry_cost_fixed_amount_Italy] [float] NULL,
	[OO_Financial_Instrument_maximum_entry_cost_acquired] [float] NULL,
	[OO_Financial_Instrument_maximum_exit_cost] [float] NULL,
	[OO_Financial_Instrument_maximum_exit_cost_fixed_amount_Italy] [float] NULL,
	[OO_Financial_Instrument_maximum_exit_cost_acquired] [float] NULL,
	[OO_Financial_Instrument_Typical_exit_cost] [float] NULL,
	[OO_Financial_Instrument_exit_cost_structrd_securities_prior_RHP] [float] NULL,
	[Financial_Instrument_Ongoing_costs] [float] NULL,
	[Financial_Instrument_Management_fee] [float] NULL,
	[Financial_Instrument_Distribution_fee] [float] NULL,
	[Financial_Instrument_Transaction_costs_ex_ante] [float] NULL,
	[Financial_Instrument_Incidental_costs_ex_ante] [float] NULL,
	[OO_Structured_Securities_entry_cost_ex_post] [float] NULL,
	[OO_Structured_Securities_exit_cost_ex_post] [float] NULL,
	[Financial_Instrument_Ongoing_costs_ex_post] [float] NULL,
	[Structured_Securities_Ongoing_costs_ex_post_accumulated] [float] NULL,
	[Financial_Instrument_Management_fee_ex_post] [float] NULL,
	[Financial_Instrument_Distribution_fee_ex_post] [float] NULL,
	[Financial_Instrument_Transaction_costs_ex_post] [float] NULL,
	[Financial_Instrument_Incidental_costs_ex_post] [float] NULL,
	[Beginning_Of_Calculation_Period] [date] NULL,
	[End_Of_Calculation_Period] [date] NULL,
	CONSTRAINT [mifid_pk] PRIMARY KEY CLUSTERED ([insref] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[underlyings] (
	[insref] [numeric](20, 0) NOT NULL,
	[isin] [varchar](255) NOT NULL,
	CONSTRAINT [underlyings_pkey] PRIMARY KEY CLUSTERED ([insref] ASC, [isin] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE INDEX [IX_UNDERLYINGS] ON [underlyings] ([isin]);
GO

