ALTER TABLE "trades" ALTER COLUMN "tradequantity" TYPE double precision;
ALTER TABLE "trades" ADD "mmt" character(14);
ALTER TABLE "orderbooks" ALTER COLUMN "quantity" TYPE double precision;

ALTER TABLE "l10n"
	ADD Comprehension_Alert_Portfolio character(1),
	ADD Intended_target_market_retail_investor_Portfolio character varying(750),
	ADD Investment_objective_Portfolio character varying(2500),
	ADD Risk_narrative_Portfolio character varying(300),
	ADD Other_materially_relevant_risk_narrative_Portfolio character varying(200),
	ADD Type_of_underlying_Investment_Option character varying(300),
	ADD Capital_Guarantee character(1),
	ADD Capital_Guarantee_Level double precision,
	ADD Capital_Guarantee_Limitations character varying(300),
	ADD Capital_Guarantee_Early_Exit_Conditions date,
	ADD Capital_guarantee_Portfolio character varying(2500),
	ADD Possible_maximum_loss_Portfolio double precision,
	ADD Portfolio_Performance_Fees_Narrative character varying(300),
	ADD Portolio_Carried_Interest_Narrative character varying(300),
	ADD Other_comment text default NULL;

CREATE TABLE "priip" (
	insref numeric(20) NOT NULL,
	Portfolio_Issuer_Name character varying(255),
	Portfolio_Guarantor_Name character varying(255),
	Portfolio_Identifying_Data character varying(255),
	Type_Of_Identification_Code_For_The_Fund_Share_Or_Portfolio smallint,
	Portfolio_Name character varying(255),
	Share_Class_Currency character(3),
	Reference_Date date,
	Portfolio_PRIIPS_Category smallint,
	Fund_CIC_code character(4),
	EOS_portfolio character(1),
	Valuation_Frequency smallint,
	Portfolio_VEV_Reference double precision,
	IS_Flexible character(1),
	Flex_VEV_Historical double precision,
	Flex_VEV_Ref_Asset_Allocation double precision,
	IS_Risk_Limit_Relevant character(1),
	Flex_VEV_Risk_Limit double precision,
	Existing_Credit_Risk character(1),
	SRI smallint,
	MRM smallint,
	CRM smallint,
	Recommended_Holding_Period double precision,
	Maturity_Date date,
	Liquidity_Risk character(1),
	Portfolio_return_unfavorable_scenario_1_year double precision,
	Portfolio_return_unfavorable_scenario_half_RHP double precision,
	Portfolio_return_unfavorable_scenario_RHP double precision,
	Portfolio_return_moderate_scenario_1_year double precision,
	Portfolio_return_moderate_scenario_half_RHP double precision,
	Portfolio_return_moderate_scenario_RHP double precision,
	Portfolio_return_favorable_scenario_1_year double precision,
	Portfolio_return_favorable_scenario_half_RHP double precision,
	Portfolio_return double precision,
	Portfolio_return_stress_scenario_1_year double precision,
	Portfolio_return_stress_scenario_half_RHP double precision,
	Portfolio_return_stress_scenario_RHP double precision,
	Portfolio_number_of_observed_return_M0 double precision,
	Portfolio_mean_observed_returns_M1 double precision,
	Portfolio_observed_Sigma double precision,
	Portfolio_observed_Skewness double precision,
	Portfolio_observed_Excess_Kurtosis double precision,
	Portfolio_observed_Stressed_Volatility double precision,
	One_off_cost_Portfolio_entry_cost double precision,
	One_off_cost_Portfolio_entry_cost_Acquired double precision,
	One_off_costs_Portfolio_exit_cost_at_RHP double precision,
	One_off_costs_Portfolio_exit_cost_at_1_year double precision,
	One_off_costs_Portfolio_exit_cost_at_half_RHP double precision,
	One_off_costs_Portfolio_sliding_exit_cost_Indicator character(1),
	Ongoing_costs_Portfolio_other_costs double precision,
	Ongoing_costs_Portfolio_management_costs double precision,
	Ongoing_costs_Portfolio_transaction_costs double precision,
	Existing_performance_fees character(1),
	Incidental_costs_Portfolio_performance_fees double precision,
	Existing_carried_interest_fees character(1),
	Incidental_costs_Portfolio_carried_interest double precision,
	Reference_Language character(2),
	Comprehension_Alert_Portfolio character(1),
	Intended_target_market_retail_investor_Portfolio character varying(750),
	Investment_objective_Portfolio character varying(2500),
	Risk_narrative_Portfolio character varying(300),
	Other_materially_relevant_risk_narrative_Portfolio character varying(200),
	Type_of_underlying_Investment_Option character varying(300),
	Capital_Guarantee character(1),
	Capital_Guarantee_Level double precision,
	Capital_Guarantee_Limitations character varying(300),
	Capital_Guarantee_Early_Exit_Conditions date,
	Capital_guarantee_Portfolio character varying(2500),
	Possible_maximum_loss_Portfolio double precision,
	Portfolio_Performance_Fees_Narrative character varying(300),
	Portolio_Carried_Interest_Narrative character varying(300),
	Other_comment text default NULL,
	PRIIP_data_delivery character(1),
	UCITS_data_delivery character(1),
	Portfolio_UCITS_SRRI smallint,
	Portfolio_UCITS_Vol double precision,
	Ongoing_costs_Portfolio_other_costs_UCITS double precision,
	Ongoing_costs_Portfolio_transaction_costs_UCITS double precision,
	Transactions_costs_methodology character varying(255),
	Incidental_costs_Portfolio_performance_fees_UCITS double precision,
	Incidental_costs_Portfolio_carried_interest_UCITS double precision,
	UCITS_KID_Web_Address text default NULL,
	Bonds_Weight double precision,
	Annualized_Return_Volatility double precision,
	Duration_Bonds double precision,
	Existing_Capital_Preservation character(1),
	Capital_Preservation_Level double precision,
	Time_Interval_Maximum_Loss character varying(10),
	Uses_PI character(1),
	Multiplier_PI double precision,
	Total_cost_1_year double precision,
	RIY_1_year double precision,
	Total_cost_half_RHP double precision,
	RIY_half_RHP double precision,
	Total_cost_RHP double precision,
	RIY_RHP double precision,
	One_off_costs_Portfolio_entry_cost_RIY double precision,
	One_off_costs_Portfolio_exit_cost_RIY double precision,
	Ongoing_costs_Portfolio_transaction_costs_RIY double precision,
	Ongoing_costs_Other_ongoing_costs_RIY double precision,
	Incidental_costs_Portfolio_performance_fees_RIY double precision,
	Incidental_costs_Portfolio_carried_interests_RIY double precision,
	CONSTRAINT priip_pk PRIMARY KEY ("insref")
);

CREATE TABLE "mifid" (
	insref numeric(20) NOT NULL,
	fisn character varying(35),
	lei character(20),
	Financial_Instrument_Identifying_Data character varying(255),
	Type_Of_Identification_Code_For_The_Financial_Instrument smallint,
	Financial_Instrument_Name character varying(255),
	Financial_Instrument_Currency character(3),
	Reporting_Date date,
	Financial_Instrument_Legal_Structure character varying(2),
	Financial_Instrument_Issuer_Name character varying(255),
	Financial_Instrument_Guarantor_Name character varying(255),
	Product_Category_or_Nature character varying(255),
	Leveraged_Financial_Instrument_or_Contingent_LiabilityInstrumen character(1),
	Investor_Type_Retail character(1),
	Investor_Type_Professional character(1),
	Investor_Type_Eligible_Counterparty character(1),
	Basic_Investor character(1),
	Informed_Investor character(1),
	Advanced_Investor character(1),
	Expert_Investor_Germany character(1),
	No_Capital_Loss character(1),
	Limited_Capital_Loss character(1),
	Limited_Capital_Loss_Level double precision,
	No_Capital_Guarantee character(1),
	Loss_Beyond_Capital character(1),
	Risk_Tolerance_PRIIPS_Methodology smallint,
	Risk_Tolerance_UCITS_Metholodology smallint,
	Risk_Tolerance_Internal_Methodology_For_Non_PRIIPS_and_NonUCITS character(1),
	Risk_Tolerance_For_Non_PRIIPS_and_Non_UCITS_Spain smallint,
	Not_For_Investors_With_The_Lowest_Risk_Tolerance_Germany character(1),
	Return_Profile_Preservation character(1),
	Return_Profile_Growth character(1),
	Return_Profile_Income character(1),
	Return_Profile_Hedging character(1),
	Option_or_Leveraged_Return_Profile character(1),
	Return_Profile_Other character(1),
	Return_Profile_Pension_Scheme_Germany character(1),
	Time_Horizon1 character(1),
	Time_Horizon2 double precision,
	Maturity_Date date,
	May_Be_Terminated_Early character(1),
	Specific_Investment_Need character(1),
	Execution_Only character(1),
	Execution_With_Appropriateness_Test_Or_Non_Advised_Services character(1),
	Investment_Advice character(1),
	Portfolio_Management character(1),
	Structured_Securities_Quotation character(1),
	OO_Financial_Instrument_entry_cost double precision,
	OO_Financial_Instrument_maximum_entry_cost_fixed_amount_Italy double precision,
	OO_Financial_Instrument_maximum_entry_cost_acquired double precision,
	OO_Financial_Instrument_maximum_exit_cost double precision,
	OO_Financial_Instrument_maximum_exit_cost_fixed_amount_Italy double precision,
	OO_Financial_Instrument_maximum_exit_cost_acquired double precision,
	OO_Financial_Instrument_Typical_exit_cost double precision,
	OO_Financial_Instrument_exit_cost_structrd_securities_prior_RHP double precision,
	Financial_Instrument_Ongoing_costs double precision,
	Financial_Instrument_Management_fee double precision,
	Financial_Instrument_Distribution_fee double precision,
	Financial_Instrument_Transaction_costs_ex_ante double precision,
	Financial_Instrument_Incidental_costs_ex_ante double precision,
	OO_Structured_Securities_entry_cost_ex_post double precision,
	OO_Structured_Securities_exit_cost_ex_post double precision,
	Financial_Instrument_Ongoing_costs_ex_post double precision,
	Structured_Securities_Ongoing_costs_ex_post_accumulated double precision,
	Financial_Instrument_Management_fee_ex_post double precision,
	Financial_Instrument_Distribution_fee_ex_post double precision,
	Financial_Instrument_Transaction_costs_ex_post double precision,
	Financial_Instrument_Incidental_costs_ex_post double precision,
	Beginning_Of_Calculation_Period date,
	End_Of_Calculation_Period date,
	CONSTRAINT mifid_pk PRIMARY KEY ("insref")
);

CREATE TABLE "underlyings" (
	"insref" numeric(20) NOT NULL,
	"isin" character varying(255) NOT NULL,
	CONSTRAINT underlyings_pk PRIMARY KEY ("insref","isin")
);

CREATE INDEX idx_underlyings ON underlyings ("isin");

